*! version 5.0
* 13 August 2018
* NIDS
* Master Income do file updated for Nids Wave 4

* THIS IS 7th INCOME DO FILE - POST-IMPUTATION AGGREGATION DO FILE: 7 OF 7
* THIS DO FILE AGGREGATES THE POST-IMPUTATION INCOME VARIABLES

*=====================================================================================================================================
* GLOBALS FOR DATA FILES, DO FILES AND VERSION SUFFIXES

* DEFINED IN "Master Income do file (1 of 7)" 

version 12.1

*=====================================================================================================================================

* OPENING DATASET CREATED IN DO FILE "Income - Performing Imputations for missing data on Income varaibles (4 of 7)" 

use "$DataOUT\impdata.dta", clear

*-------------------------------------------------------------------------------------------------------------------------------------

* UNIT NON-RESPONCE RATE

sort w4_hhid
egen hhunitR=sum(response), by(w4_hhid)
gen temp=1 if pid!=.
egen hhsize_adult=count(temp), by(w4_hhid)
drop temp
gen hhunitNRR=1-(hhunitR/hhsize_adult)
recode hhunitNRR (0=0 "0%") (0.0001/0.24999=1 "0%-25%") (0.25/0.4999=2 "25% - 49%") ///
(0.5/0.74999=3 "50% - 74%") (0.75/0.999=4 "75% - 100%") (1=5 "100%"), gen(hhunitNRR_6)

*-------------------------------------------------------------------------------------------------------------------------------------

* IMPUTATIONS FOR WAGE INCOME FOR NON-RESPONDERS

* Wage income for smooth
egen wageincome=rowtotal(fwag_imp cwag_imp swag_imp cheq_imp bonu_imp), mi
replace wageincome=. if response==0

*-------------------------------------------------------------------------------------------------------------------------------------

* ALLOCATING INCOME TO GENERAL CATEGORIES

* Total labour market income for smooth
egen labourincome=rowtotal(wageincome help_imp prof_imp extr_imp), mi
label variable labourincome "Monthly income from all labour market sources"

* Government income
egen governmentincome=rowtotal(spen dis chld fost cdep), mi
replace governmentincome=0 if governmentincome<10 
label variable governmentincome "Monthly income from government grants"

* Other government income
egen otherincome=rowtotal(uif_imp comp_imp), mi
label variable otherincome "Monthly income from UIF and/or workers compensation"

* Investment income from stocks, loans, rentals, private pensions, retirement annuities...
egen investmentincome=rowtotal(indi_imp rnt_imp ppen_imp), mi
label variable investmentincome "Monthly income from divideds, interest, priv pension, retirement annuities"

* Income of a capital nature
egen capitalincome=rowtotal(inhe_imp retr_imp brid_imp gift_imp loan_imp sale_imp othe_imp), mi
label variable capitalincome "Monthly income of a capital nature"

* Remittances
gen remittanceincome=remt_imp
label variable remittanceincome "Monthly income from all remittances"

replace hhagric=. if hhagric==0

*-------------------------------------------------------------------------------------------------------------------------------------

* AGGREGATING

* Household income data

* Household-level income categories
egen hhwage=sum(labourincome), by(w4_hhid)
replace hhwage=. if hhwage==0
label variable hhwage "Household monthly income from labour market"
egen hhgovt=sum(governmentincome), by(w4_hhid)
replace hhgovt=. if hhgovt==0
label variable hhgovt "Household monthly income from government grants"
egen hhother=sum(otherincome), by(w4_hhid)
replace hhother=. if hhother==0
label variable hhother "Household monthly income from other government sources"
egen hhinvest=sum(investmentincome), by(w4_hhid)
replace hhinvest=. if hhinvest==0
label variable hhinvest "Household monthly income from investments"
egen hhcapital=sum(capitalincome), by(w4_hhid)
replace hhcapital=. if hhcapital==0
label variable hhcapital "Household monthly income of a capital nature"
egen hhremitt=sum(remittanceincome), by(w4_hhid)
replace hhremitt=. if hhremitt==0
label variable hhremitt "Household monthly income from remittances"
gen hhimprent=imprent
label variable hhimprent "Household monthly implied rental income"

gen hhimprent_flg=rent_would_data
label variable hhimprent_flg "The monthly household implied rental income data is from:"
label define hhimprent_flg 0 "Survey" 1 "Imputed" 2 "Not Imputed" 3 "Missing", modify
label values hhimprent_flg hhimprent_flg

* Count of number of respondents who have missings or refusals to most important inc questions
local listing="proxyinc remt_rec em* inc*"
gen misinc=0
foreach x of varlist em1 ems emc incgovpen incchld {
replace misinc=misinc+1 if `x'==-3 | `x'==-8 | `x'==-9
}
egen temp=sum(misinc), by(w4_hhid)
replace misinc=temp
drop temp

* Dealing with HHs with PUNR and a missing answer for household one-shot income
replace hhwage=. if hhunitNRR>0
replace hhgovt=. if hhunitNRR>0
replace hhother=. if hhunitNRR>0
replace hhinvest=. if hhunitNRR>0
replace hhcapital=. if hhunitNRR>0
replace hhremitt=. if hhunitNRR>0
replace hhagric=. if hhunitNRR>0

* Total smooth income
egen hhincome=rowtotal(hhwage hhgovt hhother hhinvest hhremitt hhagric), mi
replace hhincome=. if misinc>0   
replace hhincome=. if hhincome==0
gen hhincome_flg=1 if hhincome!=.
replace hhincome=hhq_incb_imp if hhincome==. & hhq_incb_rec==1
replace hhincome_flg=2 if hhincome!=. & hhincome_flg!=1
egen temp=rowtotal(hhwage hhgovt hhother hhinvest hhremitt hhagric), mi
replace hhincome=temp if hhincome==. & hhq_incb_rec==1 
replace hhincome_flg=3 if hhincome!=. & hhincome_flg==.
drop temp
egen temp=rowtotal(hhincome hhimprent), m
replace hhincome=temp
drop temp
label variable hhincome_flg "The source of the monthly income data for this household is:"
label define hhincome_flg 1 "Individual" 2 "Household" 3 "Individual - sig. imp"
label values hhincome_flg hhincome_flg
label variable hhincome "Household monthly income - full imputations"
foreach var of varlist hhwage hhgov hhother hhremitt hhinvest hhagric{
replace `var'=. if hhincome_flg==2
replace `var'=. if hhunitNRR>0
}
sort w4_hhid
foreach var of varlist hhwage hhgov hhother hhremitt hhinvest hhagric {
count if `var'>hhincome & `var'!=. & w4_hhid!=w4_hhid[_n-1]
}

save "$DataOUT\hhdata.dta", replace

* end of do file 
*=====================================================================================================================================
